#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <sstream>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
    , ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    pTimer = new Timer;
    connect(ui->pushButtonTime, &QPushButton::clicked, pTimer, &Timer::readTime);
    connect(pTimer, &Timer::newValue, this, &MainWindow::showTime);
}

MainWindow::~MainWindow()
{
    delete pTimer;
    delete ui;
}

void MainWindow::on_pushButtonExit_clicked()
{
    exit(0);
}

void MainWindow::showTime(std::stringstream *pSout)
{
    std::string s = pSout ->str();
    QString qs = QString::fromStdString(s);
    ui->lineEditNow->setText(qs);
    pSout->str("");
}




